# 自动重启服务

一个Python编写的自动重启服务，可每15天自动重启系统，重启前发送邮件通知，并支持作为Windows系统服务运行。

## 功能特点

- **定时重启**：每15天自动重启系统
- **邮件通知**：重启前发送邮件提醒（24小时前和30分钟前）
- **状态记录**：记录最后重启时间，系统重启后自动重新计时
- **开机自启**：支持作为Windows系统服务运行，实现开机自动启动
- **灵活配置**：支持自定义邮件设置、警告时间和检查间隔

## 系统要求

- Windows操作系统
- Python 3.6 或更高版本

## 安装与配置

### 1. 基本安装

1. 确保已安装Python 3.6或更高版本
2. 下载或克隆本项目到本地
3. 进入项目目录

### 2. 配置邮件设置

在使用前，需要配置邮件设置以便发送通知。有两种方法可以创建配置文件：

#### 方法一：使用配置示例

运行以下命令创建配置示例文件：

```
python install_service.py --create-config
```

然后编辑生成的 `reboot_config_example.json` 文件，填写您的邮件信息，保存后重命名为 `reboot_config.json`。

#### 方法二：直接编辑配置文件

创建或编辑 `reboot_config.json` 文件，内容如下：

```json
{
    "email": {
        "smtp_server": "smtp.example.com",
        "smtp_port": 587,
        "username": "your_email@example.com",
        "password": "your_password",
        "sender": "your_email@example.com",
        "recipients": ["admin@example.com"]
    },
    "reboot_warning_hours": 24,
    "reboot_warning_minutes": 30,
    "check_interval_seconds": 3600
}
```

**重要提示**：
- 对于QQ邮箱、网易邮箱等，需要使用授权码而非登录密码
- 确保SMTP服务器地址和端口正确
- 确保收件人邮箱格式正确

### 3. 测试邮件功能

在安装服务前，建议先测试邮件功能是否正常：

```
python auto_reboot_service.py --test-email
```

如果收到测试邮件，表示配置正确。

### 4. 安装为Windows服务

以管理员身份运行命令提示符或PowerShell，然后执行：

```
python install_service.py
```

按照提示操作，服务将自动安装并启动。

## 使用方法

### 作为系统服务运行（推荐）

服务安装成功后，将自动随系统启动，并在后台运行。您可以通过Windows服务管理器（services.msc）查看和管理服务。

服务名称：`AutoRebootService`
显示名称：`自动重启服务`

### 手动运行（测试模式）

您也可以使用批处理脚本手动运行服务（非服务模式）：

1. 双击 `run_service.bat` 文件
2. 按照提示操作

此模式下，服务将在命令窗口中运行，关闭窗口将停止服务。

## 管理命令

### 安装服务
```
python install_service.py
```

### 卸载服务
```
python install_service.py --uninstall
```

### 更新服务（当程序文件更新后）
```
python install_service.py --update
```

### 查看当前配置
```
python auto_reboot_service.py --config
```

## 日志文件

- `auto_reboot.log` - 服务运行日志
- `service_install.log` - 服务安装/卸载日志

## 常见问题

### 1. 邮件发送失败

- 检查SMTP服务器地址和端口是否正确
- 确保使用的是授权码而非登录密码（特别是QQ邮箱、网易邮箱等）
- 确认发件人邮箱账号密码正确
- 检查网络连接和防火墙设置

### 2. 服务安装失败

- 确保以管理员身份运行安装脚本
- 检查Python环境是否正确安装
- 查看 `service_install.log` 了解详细错误信息

### 3. 服务无法启动

- 检查配置文件格式是否正确
- 确认Python环境可用
- 查看Windows事件查看器中的错误信息

## 注意事项

- 请确保在重要时段前完成配置，避免服务意外重启系统
- 建议定期检查服务是否正常运行
- 对于生产环境，建议先在测试环境验证功能
- 重启前请确保所有重要工作已保存

## 许可证

本项目仅供学习和使用，请勿用于非法用途。