@echo off

REM 自动重启服务 - 快速安装与配置脚本
REM 此脚本将帮助您安装服务并配置基本设置

setlocal enabledelayedexpansion

REM 获取脚本所在目录
set "SCRIPT_DIR=%~dp0"
cd /d "%SCRIPT_DIR%"

echo ===================================================================
echo                自动重启服务 - 快速安装向导                
echo ===================================================================
echo 
echo 此脚本将帮助您安装自动重启服务并配置基本设置。
echo 请确保已安装Python 3.6或更高版本。
echo 

REM 检查Python是否安装
python --version >nul 2>nul
if %errorlevel% neq 0 (
    echo 错误：未找到Python环境！
    echo 请先安装Python 3.6或更高版本，然后重试。
    echo 
    echo 您可以从以下网址下载Python：
    echo https://www.python.org/downloads/
    echo 
    pause
    exit /b 1
)

:check_config
REM 检查配置文件是否存在
if not exist "reboot_config.json" (
    echo 未找到配置文件，正在复制示例配置...
    copy "reboot_config_example.json" "reboot_config.json" >nul
    
    echo 
    echo 已创建默认配置文件，请根据您的实际情况修改。
    echo 
    echo 请选择您使用的邮箱类型：
    echo 1. QQ邮箱
    echo 2. 网易163邮箱
    echo 3. Gmail
    echo 4. 阿里云企业邮箱
    echo 5. 其他邮箱（手动配置）
    echo 
    set /p email_type=请输入选项 (1-5): 
    
    echo 
    set /p email=请输入您的邮箱地址: 
    
    REM 提示用户获取授权码
    if %email_type% equ 1 (
        echo 
        echo 对于QQ邮箱，请按照以下步骤获取授权码：
        echo 1. 登录QQ邮箱网页版
        echo 2. 点击"设置" - "账户"
        echo 3. 找到"POP3/IMAP/SMTP/Exchange/CardDAV/CalDAV服务"
        echo 4. 开启"SMTP服务"
        echo 5. 生成授权码（可能需要短信验证）
        echo 
        echo 注意：请使用授权码而非登录密码！
        echo 
    ) else if %email_type% equ 2 (
        echo 
        echo 对于网易163邮箱，请按照以下步骤获取授权码：
        echo 1. 登录网易邮箱网页版
        echo 2. 点击"设置" - "POP3/SMTP/IMAP"
        echo 3. 开启"IMAP/SMTP服务"
        echo 4. 获取授权码
        echo 
        echo 注意：请使用授权码而非登录密码！
        echo 
    ) else if %email_type% equ 3 (
        echo 
        echo 对于Gmail，请按照以下步骤配置：
        echo 1. 开启两步验证
        echo 2. 创建应用专用密码
        echo 
        echo 注意：需要使用应用专用密码而非登录密码！
        echo 
    ) else if %email_type% equ 4 (
        echo 
        echo 对于阿里云企业邮箱，请按照以下步骤配置：
        echo 1. 登录阿里云企业邮箱管理后台
        echo 2. 确认SMTP服务已开启
        echo 
    )
    
    set /p password=请输入您的邮箱密码或授权码: 
    echo 
    set /p recipient=请输入接收通知的邮箱地址: 
    
    REM 修改配置文件
    echo 正在更新配置文件...
    
    python -c "
import json
import re

try:
    # 读取配置文件
    with open('reboot_config.json', 'r', encoding='utf-8') as f:
        config = json.load(f)
    
    # 更新邮箱配置
    config['email']['username'] = '%email%'
    config['email']['password'] = '%password%'
    config['email']['sender'] = '%email%'
    config['email']['recipients'] = ['%recipient%']
    
    # 根据选择的邮箱类型设置SMTP服务器
    email_type = %email_type%
    if email_type == 1:
        config['email']['smtp_server'] = 'smtp.qq.com'
        config['email']['smtp_port'] = 587
    elif email_type == 2:
        config['email']['smtp_server'] = 'smtp.163.com'
        config['email']['smtp_port'] = 25
    elif email_type == 3:
        config['email']['smtp_server'] = 'smtp.gmail.com'
        config['email']['smtp_port'] = 587
    elif email_type == 4:
        config['email']['smtp_server'] = 'smtp.qiye.aliyun.com'
        config['email']['smtp_port'] = 465
    
    # 保存更新后的配置
    with open('reboot_config.json', 'w', encoding='utf-8') as f:
        json.dump(config, f, indent=4, ensure_ascii=False)
    
    print('配置文件已更新')
except Exception as e:
    print(f'更新配置文件时出错: {e}')
"
    
    echo 配置完成！
    echo 
    
    REM 测试邮件功能
    echo 正在测试邮件功能...
    python auto_reboot_service.py --test-email
    
    echo 
    set /p test_result=邮件测试是否成功？(y/n): 
    if /i "%test_result%" neq "y" (
        echo 
        echo 请检查您的邮箱设置是否正确，然后重试。
        echo 您可以手动编辑 reboot_config.json 文件修改配置。
        echo 
        pause
        goto check_config
    )
)

:install_service
REM 安装服务
cls
echo ===================================================================
echo                正在安装自动重启服务                
echo ===================================================================
echo 

echo 安装服务需要管理员权限，请确认...

REM 使用PowerShell以管理员身份运行安装脚本
powershell -Command "Start-Process -FilePath 'python' -ArgumentList 'install_service.py' -Verb RunAs -Wait"

REM 检查安装是否成功
sc query "AutoRebootService" >nul 2>nul
if %errorlevel% equ 0 (
    echo 
    echo ===================================================================
    echo                自动重启服务安装成功                
    echo ===================================================================
    echo 
    echo 服务名称: AutoRebootService
    echo 显示名称: 自动重启服务
    echo 
    echo 服务已设置为自动启动，将随系统一起运行。
    echo 您可以在Windows服务管理器 (services.msc) 中查看和管理此服务。
    echo 
    echo 重启时间间隔: 15天
    echo 重启前将发送邮件通知。
    echo 
    echo 如需卸载服务，请运行: python install_service.py --uninstall
    echo 
) else (
    echo 
    echo 服务安装失败！请手动尝试以下步骤：
    echo 1. 右键点击 install_service.py
    echo 2. 选择 "以管理员身份运行"
    echo 3. 按照提示完成安装
    echo 
)

pause
endlocal