@echo off

REM 自动重启服务 - 启动脚本
REM 用于手动运行服务（非服务模式）

setlocal enabledelayedexpansion

REM 检查Python是否安装
python --version >nul 2>nul
if %errorlevel% neq 0 (
    echo 错误：未找到Python环境
    echo 请先安装Python 3.6或更高版本
    pause
    exit /b 1
)

REM 获取脚本所在目录
set "SCRIPT_DIR=%~dp0"
cd /d "%SCRIPT_DIR%"

echo ===================================================================
echo                  自动重启服务 - 手动运行模式                  
echo ===================================================================
echo 
echo 此脚本用于手动运行自动重启服务，不注册为系统服务

REM 检查是否存在配置文件
if not exist "reboot_config.json" (
    echo 警告：未找到配置文件 reboot_config.json
    echo 正在创建默认配置文件...
    
    REM 创建默认配置文件
    python -c "
import json
config = {
    'email': {
        'smtp_server': 'smtp.example.com',
        'smtp_port': 587,
        'username': 'your_email@example.com',
        'password': 'your_password',
        'sender': 'your_email@example.com',
        'recipients': ['admin@example.com']
    },
    'reboot_warning_hours': 24,
    'reboot_warning_minutes': 30,
    'check_interval_seconds': 3600
}
with open('reboot_config.json', 'w', encoding='utf-8') as f:
    json.dump(config, f, indent=4, ensure_ascii=False)
print('默认配置文件已创建')
"
    
    echo 
    echo 请编辑 reboot_config.json 文件，配置您的邮件设置
    echo 
    echo 邮件配置示例（以QQ邮箱为例）：
    echo smtp_server: smtp.qq.com
    echo smtp_port: 587
    echo username: 您的QQ邮箱
    echo password: 您的邮箱授权码（不是登录密码）
    echo 
    pause
)

echo 
:start_service
cls
echo ===================================================================
echo                  自动重启服务 - 正在运行                   
echo ===================================================================
echo 
echo 服务正在运行中...
echo 按 Ctrl+C 停止服务

REM 运行主程序
python auto_reboot_service.py

REM 检查退出代码
if %errorlevel% neq 0 (
    echo 
    echo 服务异常退出！
    echo 退出代码: %errorlevel%
    echo 按任意键重试，或按 Ctrl+C 退出
    pause >nul
    goto start_service
)

endlocal
pause