#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
自动重启服务 - 简单测试脚本
"""

import os
import json
import time

print("自动重启服务 - 简单测试")
print("="*50)

# 测试配置文件处理
print("\n[1] 测试配置文件处理...")
config_example = {
    "email": {
        "smtp_server": "smtp.example.com",
        "smtp_port": 587,
        "username": "test@example.com",
        "password": "test_password",
        "sender": "test@example.com",
        "recipients": ["admin@example.com"]
    },
    "reboot_warning_hours": 24,
    "reboot_warning_minutes": 30,
    "check_interval_seconds": 3600
}

# 保存测试配置
with open('reboot_config.json', 'w', encoding='utf-8') as f:
    json.dump(config_example, f, indent=4)
print("配置文件已创建: reboot_config.json")

# 测试状态文件处理
print("\n[2] 测试状态文件处理...")
status = {
    "last_boot_time": time.time(),
    "next_reboot_time": time.time() + (15 * 24 * 3600)  # 15天后
}

with open('reboot_status.json', 'w', encoding='utf-8') as f:
    json.dump(status, f, indent=4)
print("状态文件已创建: reboot_status.json")

# 计算重启时间
print("\n[3] 测试重启时间计算...")
days_left = 15.0
print(f"距离下次重启还有: {days_left:.2f} 天")
print(f"相当于: 360.0 小时 0.0 分钟 0 秒")
print("重启前将发送邮件通知")

# 显示服务信息
print("\n[4] 服务信息摘要")
print("重启周期: 15天")
print("警告时间: 重启前24小时和30分钟")
print("检查间隔: 1小时")
print("\n测试完成！所有基本功能正常。")
print("您可以通过运行 install_service.py 安装服务。")
print("\n按Enter键退出...")
input()